<?php include("includes/common.inc.php");?>
<!DOCTYPE html>
<html lang="en">
    <head>
        <meta charset="utf-8">
        <title>
            Content Management System (CMS)
        </title>
        <?php include("includes/scripts.inc.php");?>
    </head>
    <!-- BEGIN Body -->
    <!-- Possible Classes

		* 'header-function-fixed'         - header is in a fixed at all times
		* 'nav-function-fixed'            - left panel is fixed
		* 'nav-function-minify'			  - skew nav to maximize space
		* 'nav-function-hidden'           - roll mouse on edge to reveal
		* 'nav-function-top'              - relocate left pane to top
		* 'mod-main-boxed'                - encapsulates to a container
		* 'nav-mobile-push'               - content pushed on menu reveal
		* 'nav-mobile-no-overlay'         - removes mesh on menu reveal
		* 'nav-mobile-slide-out'          - content overlaps menu
		* 'mod-bigger-font'               - content fonts are bigger for readability
		* 'mod-high-contrast'             - 4.5:1 text contrast ratio
		* 'mod-color-blind'               - color vision deficiency
		* 'mod-pace-custom'               - preloader will be inside content
		* 'mod-clean-page-bg'             - adds more whitespace
		* 'mod-hide-nav-icons'            - invisible navigation icons
		* 'mod-disable-animation'         - disables css based animations
		* 'mod-hide-info-card'            - hides info card from left panel
		* 'mod-lean-subheader'            - distinguished page header
		* 'mod-nav-link'                  - clear breakdown of nav links

		>>> more settings are described inside documentation page >>>
	-->
    <body>
        <div class="page-wrapper auth">
            <div class="page-inner bg-brand-gradient">
                <div class="page-content-wrapper bg-transparent m-0">
                    <div class="height-10 w-100 shadow-lg px-4 bg-brand-gradient">
                        <div class="d-flex align-items-center container p-0">
                            <div class="page-logo width-mobile-auto m-0 align-items-center justify-content-center p-0 bg-transparent bg-img-none shadow-0 height-9 border-0">
                                <a href="javascript:void(0)" class="page-logo-link press-scale-down d-flex align-items-center">
                                    <img src="img/general/1556_education-logo_white.png" alt="IYC" aria-roledescription="logo">
                                    <!--<span class="page-logo-text mr-1 fw-700">(CMS)</span>-->
                                </a>
                            </div>
                            
                        </div>
                    </div>
                    <div class="flex-1" style="background: url(img/svg/pattern-1.svg) no-repeat center bottom fixed; background-size: cover;">
                        <div class="container py-4 py-lg-5 my-lg-5 px-4 px-sm-0">
                            <div class="row">
                                <div class="col col-md-6 col-lg-7 hidden-sm-down" style="background: url(img/index_img2.png) no-repeat left; height: 350px;">
                                    <!--Add left side panel-->
                                    
                                </div>
                                <div class="col-sm-12 col-md-6 col-lg-5 col-xl-4 ml-auto">
                                    <h1 class="text-white fw-300 mb-3 d-sm-block d-md-none">
                                        Secure login
                                    </h1>
                                    <div class="card p-4 rounded-plus bg-faded">
										<h1 class="text-primary subheader-title text-center wf-700"> Login</h1>
                                        <form id="FrmLogin" action="login.php" method="post">
                                            <div class="form-group">
                                                <label class="form-label" for="username">Username</label>
                                                <input type="text" name="username" id="username" class="form-control form-control-lg" placeholder="User Name" value="" required>
                                                <!-- <div class="invalid-feedback">No, you missed this one.</div> -->
                                            </div>
                                            <div class="form-group">
                                                <label class="form-label" for="password">Password</label>
                                                <input type="password" name="password" id="password" class="form-control form-control-lg" placeholder="Password" value="" required>
                                                <!-- <div class="invalid-feedback">Sorry, you missed this one.</div> -->
												<span id="login_error" class="mt-0" style="color: red;" hidden>Username or Password is not Correct</span>
                                            </div>
                                            		
											
                                            <div class="row no-gutters">
                                            	<div class="col-lg-6 pr-lg-1 my-2">
                                                    <a type="submit" class="btn forgotPass" data-toggle="modal" data-target="#myForgotPass" href="javascript:;">Forgot Password?</a>
                                                </div>
                                                <div class="col-lg-6 pl-lg-1 my-2 text-center">
                                                    <button id="js-login-btn" type="submit" class="btn btn-danger btn-lg">Secure login</button>
                                                </div>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                            <div class="position-absolute pos-bottom pos-left pos-right p-3 text-center text-white">

                                <span class="hidden-md-down fw-700"><?php date("Y");?> &copy; MaxEase International by&nbsp;<a href='http://maxease.com/' class=' fw-500' title='maxrease.com' target='_blank'>maxease.com</a></span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div id="myForgotPass" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
            <form action="#" method="post" id="FrmFP" enctype="multipart/form-data">
            <input type="hidden" name="loginid" id="loginid" value="1" />
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title">Forgot Password</h5>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true"><i class="fal fa-times"></i></span>
                            </button>
                        </div>
                        <div class="modal-body">
                            <div id="emailformmsg">
            
                            </div>
                            <div id="DocumentFormAddEdit">
                             <div class="row">	
                                    <div class="col-md-12">
                                        <div class="form-group">
                                            <label class="form-label" for="log_email">Enter Email</label>
                                            <input type="text" id="log_email" name="log_email" class="form-control" placeholder="Enter email" value="<?php echo $log_email;?>">
                                          </div>
                                    </div>
                                </div>
                                 <div class="modal-footer">
                                    <button type="button" class="btn btn-secondary" id="FPclose" data-dismiss="modal">Close</button>
                                    <button type="submit" id="DocumentSubmit" class="btn btn-primary">Change Password</button>
                                 </div>
                            </div>
                        </div>
                    </div>
                    <!-- /.modal-content -->
                </div>
                <!-- /.modal-dialog -->
            </form>
            </div>
        <!-- BEGIN Color profile -->
        <!-- this area is hidden and will not be seen on screens or screen readers -->
        <!-- we use this only for CSS color refernce for JS stuff -->
        <p id="js-color-profile" class="d-none">
            <span class="color-primary-50"></span>
            <span class="color-primary-100"></span>
            <span class="color-primary-200"></span>
            <span class="color-primary-300"></span>
            <span class="color-primary-400"></span>
            <span class="color-primary-500"></span>
            <span class="color-primary-600"></span>
            <span class="color-primary-700"></span>
            <span class="color-primary-800"></span>
            <span class="color-primary-900"></span>
            <span class="color-info-50"></span>
            <span class="color-info-100"></span>
            <span class="color-info-200"></span>
            <span class="color-info-300"></span>
            <span class="color-info-400"></span>
            <span class="color-info-500"></span>
            <span class="color-info-600"></span>
            <span class="color-info-700"></span>
            <span class="color-info-800"></span>
            <span class="color-info-900"></span>
            <span class="color-danger-50"></span>
            <span class="color-danger-100"></span>
            <span class="color-danger-200"></span>
            <span class="color-danger-300"></span>
            <span class="color-danger-400"></span>
            <span class="color-danger-500"></span>
            <span class="color-danger-600"></span>
            <span class="color-danger-700"></span>
            <span class="color-danger-800"></span>
            <span class="color-danger-900"></span>
            <span class="color-warning-50"></span>
            <span class="color-warning-100"></span>
            <span class="color-warning-200"></span>
            <span class="color-warning-300"></span>
            <span class="color-warning-400"></span>
            <span class="color-warning-500"></span>
            <span class="color-warning-600"></span>
            <span class="color-warning-700"></span>
            <span class="color-warning-800"></span>
            <span class="color-warning-900"></span>
            <span class="color-success-50"></span>
            <span class="color-success-100"></span>
            <span class="color-success-200"></span>
            <span class="color-success-300"></span>
            <span class="color-success-400"></span>
            <span class="color-success-500"></span>
            <span class="color-success-600"></span>
            <span class="color-success-700"></span>
            <span class="color-success-800"></span>
            <span class="color-success-900"></span>
            <span class="color-fusion-50"></span>
            <span class="color-fusion-100"></span>
            <span class="color-fusion-200"></span>
            <span class="color-fusion-300"></span>
            <span class="color-fusion-400"></span>
            <span class="color-fusion-500"></span>
            <span class="color-fusion-600"></span>
            <span class="color-fusion-700"></span>
            <span class="color-fusion-800"></span>
            <span class="color-fusion-900"></span>
        </p>
        <!-- END Color profile -->
        <!-- base vendor bundle: 
			 DOC: if you remove pace.js from core please note on Internet Explorer some CSS animations may execute before a page is fully loaded, resulting 'jump' animations 
						+ pace.js (recommended)
						+ jquery.js (core)
						+ jquery-ui-cust.js (core)
						+ popper.js (core)
						+ bootstrap.js (core)
						+ slimscroll.js (extension)
						+ app.navigation.js (core)
						+ ba-throttle-debounce.js (core)
						+ waves.js (extension)
						+ smartpanels.js (extension)
						+ src/../jquery-snippets.js (core) -->
        <?php include("includes/footer.scripts.inc.php");?>
        <style>
			/*.swal2-modal{ z-index:11111111 !important;}*/
		</style>
        <script>
		$('#FrmLogin').submit(function(e){
			e.preventDefault(); // Prevent Default Submission
			//alert(log_id);
			//swal('Wait', 'Please donot close this window', 'warning');
			
			Swal.fire(
			{
				position: "middle",
				type: "success",
				title: "Don't close this window  ",
				html: "<img src='img/loading1.gif' width='70' />",
				showConfirmButton: false
			});
			
			$.ajax({
				type: 'post',
				url: 'login.php',
				data: new FormData(this),
				contentType: false,
				data_type: 'json',
				cache: false,
				processData: false,
				beforesend: function () {
				},
				success: function (data) {
					
					//Swal.close();
					var resultArray 	= jQuery.parseJSON(data);
					var err=resultArray[0];
					var msg_title=resultArray[1];
					var msg=resultArray[2];
					var msg_type=resultArray[3];
		
					if(err=="0")
					{
						Swal.fire(''+msg_title+'', ''+msg+'', ''+msg_type+'');
					}
					else
					{
						var returnUrl=resultArray[4];
						document.location=""+returnUrl+"";
						return;
					}
		
		
				}, complete: function () {
					//$('#add_submit_btn').prop('disabled', false);
				},
				error: function (data) {
					var d = JSON.parse(data);
					swal.close();
				}
			})
		});
		
		
		
		$('#FrmFP').submit(function(e){
			e.preventDefault(); // Prevent Default Submission
			
			Swal.fire(
			{
				position: "middle",
				type: "success",
				title: "Don't close this window  ",
				html: "<img src='img/loading1.gif' width='70' />",
				showConfirmButton: false
			});
			
			$.ajax({
				type: 'post',
				url: 'forgot_password.php',
				data: new FormData(this),
				contentType: false,
				data_type: 'json',
				cache: false,
				processData: false,
				beforesend: function () {
				},
				success: function (data) {
					
					//Swal.close();
					var resultArray 	= jQuery.parseJSON(data);
					var err=resultArray[0];
					var msg_title=resultArray[1];
					var msg=resultArray[2];
					var msg_type=resultArray[3];
		
					if(err=="1")
					{
						Swal.fire(''+msg_title+'', ''+msg+'', ''+msg_type+'');
						//$("#emailformmsg").html(data);
					}
					else
					{
						$("#FrmFP")[0].reset();
						$("#FPclose").click();
						Swal.fire(''+msg_title+'', ''+msg+'', ''+msg_type+'');
					}
		
		
				}, complete: function () {
					//$('#add_submit_btn').prop('disabled', false);
				},
				error: function (data) {
					var d = JSON.parse(data);
					swal.close();
				}
			})
		});
		</script>
        <!-- Page related scripts -->
    </body>
    <!-- END Body -->
</html>
